<?php

namespace App\Console;

use Illuminate\Support\Facades\Artisan;
use Illuminate\Console\Scheduling\Schedule;
use Illuminate\Foundation\Console\Kernel as ConsoleKernel;

class Kernel extends ConsoleKernel
{
    /**
     * Define the application's command schedule.
     *
     * @param  \Illuminate\Console\Scheduling\Schedule  $schedule
     * @return void
     */
    protected function schedule(Schedule $schedule)
    {
        if(env('DEMO_MODE') == true){
            $schedule->command('demo:remove-advertisements')->daily();
            $schedule->command('demo:remove-customers')->daily();
            $schedule->command('demo:remove-chats')->daily();
            $schedule->command('demo:remove-properties')->daily();
            $schedule->command('demo:remove-projects')->daily();
        }
        $schedule->command('app:notify-expiring-subscriptions')->daily();

        // Retry failed jobs
        $schedule->command('queue:retry all')->everyMinute();
        // Work on the queue
        $schedule->command('queue:work --stop-when-empty')->everyMinute();


    }

    /**
     * Register the commands for the application.
     *
     * @return void
     */
    protected function commands()
    {
        $this->load(__DIR__.'/Commands');
        $this->load(__DIR__.'/Commands/Demo');

        require base_path('routes/console.php');
    }
}
